//**************************************************************************
// Header File Included Area
//**************************************************************************
.include 	GPCE206x.inc

//**************************************************************************
// Contant Defintion Area
//**************************************************************************
.define C_CWL_IR_Timer_Setting_X1		C_Timer_Setting_12K
.define C_CWL_IR_Timer_Setting_X2		C_Timer_Setting_24K

//**************************************************************************
// Variable Publication Area
//**************************************************************************

//**************************************************************************
// Function Call Publication Area
//**************************************************************************
.public  _ComwireLite_HW_Init
.public F_ComwireLite_HW_Init

.public F_ComwireLite_HW_Enable
.public F_ComwireLite_HW_Disable

.public F_ComwireLite_HW_GetIO

.public  _ComwireLite_HW_IR_Timer_X1
.public F_ComwireLite_HW_IR_Timer_X1
.public  _ComwireLite_HW_IR_Timer_X2
.public F_ComwireLite_HW_IR_Timer_X2

.public F_ComwireLite_HW_IR_ON
.public F_ComwireLite_HW_IR_OFF

.public F_ComwireLite_HW_INT_ON
.public F_ComwireLite_HW_INT_OFF

.external F_ComwireLite_Timer_Setting_12K		
.external F_ComwireLite_Timer_Setting_24K		

//**************************************************************************
// RAM Definition Area
//**************************************************************************
.RAM

//**************************************************************************
// CODE Definition Area
//**************************************************************************
.CODE
//****************************************************************
// Function    : F_ComwireLite_HW_Init
// Description : Initialize Comwire Lite module
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : IOA1: GPCE Tx, hardware IR
//			     IOA2: GPCE Rx, I/O
//****************************************************************
 _ComwireLite_HW_Init:		.proc
F_ComwireLite_HW_Init:

	R1 = [P_IOA_Dir];	
	R1 |= 0x0002;				
	R1 &= 0xFFFB;
	[P_IOA_Dir] = R1;			
				
	R1 = [P_IOA_Attrib];
	R1 |= 0x0006;
	[P_IOA_Attrib] = R1;
	
	R1 = [P_IOA_Buffer];
	R1 &= 0xFFFC;
	[P_IOA_Buffer] = R1;					// A1:output low(110) for 12KHz pulse, A2:input float(010) signal input	

	R1 = C_TimerA_FPLL | C_TimerB_FPLL;		// TimerA CKA=Fosc/2 CKB=1 Tout:off, TimerB CKA=Fosc/2 CKB=1 Tout:off
	[P_Timer_Ctrl] = R1;
	R1= C_Timer_Setting_8K;					// 8KHz TimerA setting, can share with other 8K/16K/24K... interrupt
	[P_TimerA_Data] = R1;
	[P_TimerA_CNTR] = R1;		

	R1= C_CWL_IR_Timer_Setting_X2;			// TimerB setting, 24KHz toggle signal, for IR
	[P_TimerB_Data] = R1;
	[P_TimerB_CNTR] = R1;
	
	R1 = [P_INT_Ctrl];
	R1 |= C_IRQ0_TMA;
	[P_INT_Ctrl] = R1;						// Enable Timer A IRQ for both TX/RX
	
	R1 = 0x0000;
	[P_FIQ_Sel] = R1;
	
	R1 = [P_IO_Ctrl];
	R1 &= ~0x03C0;							// 1/2 duty IR, TimerB as clock source
	[P_IO_Ctrl] = R1;		
	
	irq on;

	retf;
	.endp
	
//****************************************************************
// Function    : F_ComwireLite_HW_Enable
// Description : ComwireLite Enable HW setting
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_ComwireLite_HW_Enable:

	retf
		
//****************************************************************
// Function    : F_ComwireLite_HW_Disable
// Description : ComwireLite Disable HW setting
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_ComwireLite_HW_Disable:

	retf


//****************************************************************
// Function    : F_ComwireLite_HW_GetIO
// Description : return I/O status
// Destory     : R1
// Parameter   : None
// Return      : R1
// Note        : None
//****************************************************************
F_ComwireLite_HW_GetIO:
	R1 = [P_IOA_Data]
	retf
	
//****************************************************************
// Function    : F_ComwireLite_HW_IR_OFF
// Description : Disable toggle pulse
// Destory     : R1
// Parameter   : None
// Return      : R1
// Note        : None
//****************************************************************
F_ComwireLite_HW_IR_OFF:
	R1 = [P_IO_Ctrl];
	R1 &= ~C_IR_With_TimerB;			// Disable toggle pulse
	[P_IO_Ctrl] = R1;
	retf
	
//****************************************************************
// Function    : F_ComwireLite_HW_IR_ON
// Description : Enable toggle pulse
// Destory     : R1
// Parameter   : None
// Return      : R1
// Note        : None
//****************************************************************
F_ComwireLite_HW_IR_ON:
	R1 = [P_IO_Ctrl];
	R1 |= C_IR_With_TimerB;
	[P_IO_Ctrl] = R1;					
	retf

//****************************************************************
// Function    : F_ComwireLite_HW_IR_Timer_X1
// Description : TimerB setting, 12KHz toggle signal,, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _ComwireLite_HW_IR_Timer_X1:	.proc
F_ComwireLite_HW_IR_Timer_X1:	
	push R1 to [SP];
	R1 = C_CWL_IR_Timer_Setting_X1;
	[P_TimerB_Data] = R1;
	pop R1 from [SP]
	retf;
	.endp

//****************************************************************
// Function    : F_ComwireLite_HW_IR_Timer_X2
// Description : TimerB setting, 24KHz toggle signal, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _ComwireLite_HW_IR_Timer_X2:	.proc
F_ComwireLite_HW_IR_Timer_X2:	
	push R1 to [SP];
	R1 = C_CWL_IR_Timer_Setting_X2;
	[P_TimerB_Data] = R1;
	pop R1 from [SP];
	retf;
	.endp				
//****************************************************************
// Function    : F_ComwireLite_HW_INT_ON
// Description : ComwireLite callback function 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_ComwireLite_HW_INT_ON:
	IRQ	ON
	retf

//****************************************************************
// Function    : F_ComwireLite_HW_INT_OFF
// Description : ComwireLite callback function 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_ComwireLite_HW_INT_OFF:
	IRQ	OFF
	retf