//==========================================================================
// File Name   : SACM_DVRIMA_USER.asm
// Description : Users implement functions
// Written by  : Ray Cheng
// Last modified date:
//              2005/12/26
// Note: 
//==========================================================================
//**************************************************************************
// Header File Included Area
//**************************************************************************
.include GPCE206x.inc
.include DVRIMA.inc

//**************************************************************************
// Contant Defintion Area
//**************************************************************************
.define C_DVRIMA_Timer_Setting_X1		C_Timer_Setting_12K
.define C_DVRIMA_Timer_Setting_X2		C_Timer_Setting_24K
.define C_DVRIMA_Timer_Setting_X3		C_Timer_Setting_36K
.define C_DVRIMA_Timer_Setting_X4		C_Timer_Setting_48K

//**************************************************************************
// Variable Publication Area
//**************************************************************************


//**************************************************************************
// Function Call Publication Area
//**************************************************************************
.public F_USER_DVRIMA_GetData
.public F_USER_DVRIMA_WriteData
.public  _USER_DVRIMA_Volume
.public F_USER_DVRIMA_Volume
.public F_SACM_DVRIMA_GetADC
.public F_SACM_DVRIMA_SendDAC1
.public F_SACM_DVRIMA_SendDAC2
.public F_SACM_DVRIMA_StartPlay
.public F_SACM_DVRIMA_StartRecord
.public F_SACM_DVRIMA_EndRecord
.public F_SACM_DVRIMA_EndPlay
.public F_SACM_DVRIMA_Init_

.public  _SACM_DVRIMA_Timer
.public F_SACM_DVRIMA_Timer
.public F_SACM_DVRIMA_DAC_Timer_X1
.public F_SACM_DVRIMA_DAC_Timer_X2

//**************************************************************************
// External Function Declaration
//**************************************************************************
.external F_SPI_ReadNWords
.external F_SPI_SendNWords
.external F_SPI_SendAWord
.external F_SPI_ReadAWord
.external _GetData
.external _WriteData

.external F_SACM_Delay
//**************************************************************************
// External Table Declaration
//**************************************************************************
.external T_SACM_DVRIMA_SpeechTable

//**************************************************************************
// RAM Definition Area
//**************************************************************************
OVERLAP_DVRIMA_USER_BLOCK:	.section .ORAM
L_RAM_Start:
.var R_ExtMem_Low
.var R_ExtMem_High
.var R_ExtMem_Low_Con
.var R_ExtMem_High_Con
L_RAM_End:

//*****************************************************************************
// Table Definition Area
//*****************************************************************************
.TEXT
// Volume Table
T_SACM_DVRIMA_Volume_Level:
.dw 0x0000, 0x0250, 0x0500, 0x1000
.dw	0x1500, 0x2000, 0x2500, 0x3000
.dw 0x3500, 0x4000, 0x5000, 0x6500
.dw	0x7d00, 0x9c00, 0xc400, 0xf500

T_DVRIMA_Timer_Seleect:
.DW	C_DVRIMA_Timer_Setting_X1		// index 0
.DW	C_DVRIMA_Timer_Setting_X1		// index 1
.DW	C_DVRIMA_Timer_Setting_X2		// index 2
.DW	C_DVRIMA_Timer_Setting_X3		// index 3
.DW	C_DVRIMA_Timer_Setting_X4		// index 4

//**************************************************************************
// CODE Definition Area
//**************************************************************************
.CODE
//****************************************************************
// Function    : F_SACM_DVRIMA_Init_
// Description : Hardware initilazation for DVRIMA, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_SACM_DVRIMA_Init_:	.proc
	INT OFF
	FIR_MOV OFF;

	R1 = L_RAM_Start
	R2 = 0
L_ClearRAM?:	
	[R1++] = R2
	CMP R1, L_RAM_End
	JB	L_ClearRAM?
	
	R1 = C_TimerA_FPLL|C_TimerB_FPLL|C_TimerC_FPLL;				// TimerB/C for ComWireLite
	[P_Timer_Ctrl] = R1;
	R1= C_DVRIMA_Timer_Setting_X1;					
	[P_TimerA_Data] = R1;
	[P_TimerA_CNTR] = R1;

	R1= C_Timer_Setting_8K;					
	[P_TimerC_Data] = R1;
	[P_TimerC_CNTR] = R1;

	R1 = C_DAC_Enable | C_DAC_CH1_Up_Sample_Enable | C_DAC_CH1_Enable | C_DAC_CH1_TMR_Sel_TimerA;
	[P_DAC_Ctrl] = R1;	
	
	R1 = C_Ext_DAC_In_Disable | C_PP_NMOS_Enable | C_PP_Gain_LV11;
	[P_PPAMP_Ctrl] = R1;
	call F_SACM_Delay;
	R1 |= C_PP_PMOS_Enable;
	[P_PPAMP_Ctrl] = R1;

	R1 = C_ADC_Enable | C_AGC_Enable | C_ADC_CLK_FPLL_Div_32 | C_ADC_Bias_Enable | C_ADC_MIC_Enable | C_ADC_Timer_A
	[P_ADC_Ctrl] = R1;

	R1 = C_ADC_PGA_Disable;
	[P_ADC_PGA_Ctrl] = R1;

	R1 = [P_INT_Ctrl];
	R1 |= C_IRQ0_TMA| C_IRQ2_TMC;
	[P_INT_Ctrl] = R1;

	R1 = [P_FIQ_Sel];
	R1 |= C_IRQ0_TMA;
	[P_FIQ_Sel] = R1;
	
	FIQ on;
	IRQ on;
	retf;
	.endp

//****************************************************************
// Function    : F_USER_DVRIMA_Volume
// Description : Set speech volume
// Destory     : R1
// Parameter   : R1: volume index
// Return      : None
// Note        : None
//****************************************************************
 _USER_DVRIMA_Volume: .proc
	R1 = SP + 3;
	R1 = [R1];								// volume index
F_USER_DVRIMA_Volume:
	R1 += T_SACM_DVRIMA_Volume_Level;		// loop up volume table
	R1 = [R1];
	call F_SACM_DVRIMA_Volume;
	retf
	.endp

//****************************************************************
// Function    : F_SACM_DVR1800_GetADC
// Description : Get ADC data for recording
// Destory     : R1
// Parameter   : None
// Return      : R1 = ADC data
// Note        : None
//****************************************************************
F_SACM_DVRIMA_GetADC:	.proc
	R4 = [P_ADC_Data];
	R4 ^= 0x8000;
	R4 -= R4 ASR 3;
	retf;
	.endp
		
//****************************************************************
// Function    : F_SACM_DVRIMA_SendDAC1
// Description : Send data to DAC1, called by library
// Destory     : None
// Parameter   : R4: 16-bit signed PCM data
// Return      : None
// Note        : None
//****************************************************************
F_SACM_DVRIMA_SendDAC1:	.proc
	[P_DAC_CH1_Data] = R4;
	retf;
	.endp

//****************************************************************
// Function    : F_SACM_DVRIMA_SendDAC2
// Description : Send data to DAC2, called by library
// Destory     : None
// Parameter   : R4: 16-bit signed PCM data
// Return      : None
// Note        : None
//****************************************************************
F_SACM_DVRIMA_SendDAC2:	.proc
	[P_DAC_CH2_Data] = R4;
	retf; 
	.endp

//****************************************************************
// Function    : F_SACM_DVRIMA_StartPlay
// Description : This function called by library when Play function is callled
// Destory     : None
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_SACM_DVRIMA_StartPlay:	.proc
	nop;
	retf;
	.endp

//****************************************************************
// Function    : F_SACM_DVRIMA_StartRecord
// Description : This function called by library when Record function is callled
// Destory     : None
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_SACM_DVRIMA_StartRecord:	.proc
	nop;
	retf;
	.endp
	
//****************************************************************
// Function    : F_SACM_DVR1800_EndRecord
// Description : Call back from kernel when bit stream encoding is done 
// Destory     : R1, R2, R3
// Parameter   : R1: Low word of file length
//               R2: High word of File length
// Return      : None
// Note        : None
//****************************************************************
F_SACM_DVRIMA_EndRecord: .proc
	nop;
	retf;
	.endp
	
//****************************************************************
// Function    : F_SACM_DVRIMA_EndPlay
// Description : This function called by library when speech play end
// Destory     : None
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_SACM_DVRIMA_EndPlay:	.proc
	nop;
	retf;
	.endp

//****************************************************************
// Function    : F_USER_DVR1800_GetData
// Description : Get speech data from internal or external memory
//               and fill these data to buffer of library.
// Destory     : None
// Parameter   : None
// Return      : R2
// Note        : None
//****************************************************************
F_USER_DVRIMA_GetData:	.proc
	call _GetData;
	r2 = r1
	retf;
	.endp

//****************************************************************
// Function    : F_USER_DVR1800_WriteData
// Description : Get encoded speech data from buffer of library
//               and write to external memory.
// Destory     : None
// Parameter   : R2: data
// Return      : None
// Note        : None
//****************************************************************
F_USER_DVRIMA_WriteData:	.proc
	push r2 to [sp]
	call _WriteData;
	pop r2 from [sp]
	retf;
	.endp


//****************************************************************
// Function    : F_SACM_DVRIMA_DAC_Timer_X1
// Description : Change timer setting for change DA filter, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _SACM_DVRIMA_DAC_Timer_X1:	.proc
F_SACM_DVRIMA_DAC_Timer_X1:
	push R1 to [SP];
	R1 = C_DVRIMA_Timer_Setting_X1;
	[P_TimerA_Data] = R1;
	pop R1 from [SP]
	retf;
	.endp

//****************************************************************
// Function    : F_SACM_DVRIMA_DAC_Timer_X2
// Description : Set timer for DVRIMA playback, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _SACM_DVRIMA_DAC_Timer_X2:	.proc
F_SACM_DVRIMA_DAC_Timer_X2:
	push R1 to [SP];
	R1 = C_DVRIMA_Timer_Setting_X2;
	[P_TimerA_Data] = R1;
	pop R1 from [SP];
	retf;
	.endp

.comment @
//****************************************************************
// Function    : F_SACM_DVRIMA_ADC_Timer_X1
// Description : Change timer setting for change AD filter, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _SACM_DVRIMA_ADC_Timer_X1:	.proc
F_SACM_DVRIMA_ADC_Timer_X1:
	R1 = C_DVRIMA_Timer_Setting_X1;
	[P_TimerA_Data] = R1;
	retf;
	.endp

//****************************************************************
// Function    : F_SACM_DVRIMA_ADC_Timer_X2
// Description : Change timer setting for change AD filter, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _SACM_DVRIMA_ADC_Timer_X2:	.proc
F_SACM_DVRIMA_ADC_Timer_X2:
	R1 = C_DVRIMA_Timer_Setting_X2;
	[P_TimerA_Data] = R1;
	retf;
	.endp

//****************************************************************
// Function    : F_SACM_DVRIMA_ADC_Timer_X4
// Description : Set timer for DVRIMA recording, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _SACM_DVRIMA_ADC_Timer_X4:	.proc
F_SACM_DVRIMA_ADC_Timer_X4:
	push R1 to [SP];
	R1 = C_DVRIMA_Timer_Setting_X4;
	[P_TimerA_Data] = R1;
	pop R1 from [SP];
	retf;
	.endp
@	

//****************************************************************
// Function    : F_SACM_DVRIMA_ADC_Timer
// Description : Set timer for DVRIMA recording, called by library
// Destory     : R1
// Parameter   : R1: 1: X1
//					 2: X2
//					 3: X3
//					 4: X4
// Return      : None
// Note        : None
//****************************************************************
 _SACM_DVRIMA_Timer:	.proc
 	R1 = SP + 3
 	R1 = [R1]
F_SACM_DVRIMA_Timer:
	push R1 to [SP];
	R1 += T_DVRIMA_Timer_Seleect
	R1 = [R1]
	[P_TimerA_Data] = R1;
	pop R1 from [SP];
	retf;
	.endp
