.include GPCE206x.inc
.include DVR1800.inc
.include DVRIMA.inc
.include COMWIRELITE.inc

.public _BREAK;
.public _FIQ;
.public _IRQ0;
.public _IRQ1;
.public _IRQ2;
.public _IRQ3;
.public _IRQ4;
.public _IRQ5;
.public _IRQ6;
.public _IRQ7;

.external _R_TimeOut
.external _R_Alg_ID
////////////////////////////////////////////////

////////////////////////////////////////////////
.TEXT
_BREAK:
	reti;

_FIQ:	//36KHz or 16Khz
	push R1, R5 to [SP]
	R1 = [_R_Alg_ID]
	CMP R1, 1
	JNE	L_DVRIMA?
    call F_ISR_Service_SACM_DVR1800;		//16KHz
    JMP	L_ExitAlg?
L_DVRIMA?:	
    call F_ISR_Service_SACM_DVRIMA;    		//36KHz
L_ExitAlg?:		
	
	R1 = C_IRQ0_TMA;
	[P_INT_Status] = R1;
	pop R1, R5 from [SP]
	reti;

_IRQ0:
	push R1, R5 to [SP]
	pop R1, R5 from [SP]
	reti;

_IRQ1:
	push R1, R5 to [SP]
	pop R1, R5 from [SP]
	reti;

_IRQ2:		//8KHz
	push R1, R5 to [SP]

	call F_ISR_Service_ComwireLite;

	R1 = [_R_TimeOut];
	JZ	L_TimeOut?
	R1 -= 1;
	[_R_TimeOut] = R1;
L_TimeOut?:

	R1 = C_IRQ2_TMC;
	[P_INT_Status] = R1;
	pop R1, R5 from [SP]
	reti;

_IRQ3:
	push R1, R5 to [SP]
	pop R1, R5 from [SP]
	reti;

_IRQ4:
	push R1, R5 to [SP]
	pop R1, R5 from [SP]
	reti;

_IRQ5:
	push R1, R5 to [SP]
	pop R1, R5 from [SP]
	reti;

_IRQ6:
	push R1, R5 to [SP]
	pop R1, R5 from [SP]
	reti;

_IRQ7:
	push R1, R5 to [SP]
	pop R1, R5 from [SP]
	reti;
