//************************************************************************
// ComwireLite with audio download demo code
// 
// TimerA: DVR1800/DVRIMA used
// TimerB: ComwireLite TX used
// TimerC: ComwireLite interrupt service
// ComwireLite TX pin: IOA1
// ComwireLite Rx pin: IOA2
//************************************************************************
#include "SACM.h"
#include "GPCE206x.h"
#include "COMWIRELITE.h"

#define C_TimeOut				12000		// 1.5 sec

//**************************************************************************
// Function Call Publication Area
//**************************************************************************
#define C_Start					0x0100
#define C_End					0x0200
#define C_Erase					0x0400
#define C_Status				0x0600
#define C_Ack					0x0300
#define C_EraseEnd				0x0500

//DVR1800
#define C_PlayPrerecordData		0x0000
#define C_RecordData			0x0001
#define C_PlayRecordedData		0x0002
//DVRIMA
#define C_Play					0x0000	
#define C_Record				0x0001

unsigned Key;
int R_TimeOut;
int R_PlayFlag;
int R_Command;
unsigned Cmd;
unsigned temp;
unsigned R_Cmd_ID;
unsigned R_Alg_ID;
unsigned R_Bank;
unsigned Mode;
unsigned R_Volume_Index;
short *pP_IOB_Buffer = P_IOB_Buffer;

int main()
{
	System_Initial();
	ComwireLite_Init(16);
	ComwireLite_Enable();

	SPI_Initial();
	SACM_DVRIMA_Initial();		// DVRIMA initial
	SACM_DVR1800_Initial();		// DVR1800 initial

	R_TimeOut = C_TimeOut;
	R_PlayFlag = 0;
	R_Command = 0;
	Key = 0;
	*pP_IOB_Buffer = 0;
	while(1)
	{
		if(R_TimeOut == 0 && R_PlayFlag == 0)
 		{
 			if(R_Alg_ID == 1)
 			{
				SACM_DVR1800_Stop();
				while(SACM_DVR1800_Status() != 0)
				{
					System_ServiceLoop();		
				}
 			}
 			else
 			{
				SACM_DVRIMA_Stop();
				while(SACM_DVRIMA_Status() != 0)
				{
					System_ServiceLoop();		
				}
 			}
		}
					
		Key = SP_GetKeyOn();
		if(Key != 0)
		{

			if(Key == 0x0100)
			{
				R_TimeOut = C_TimeOut;
				R_PlayFlag = 1;
				R_Alg_ID = 1;

				SACM_DVRIMA_Stop();	
				SACM_DVR1800_Stop();	
				SACM_DVR1800_Initial();		
				Mode = C_PlayRecordedData;
				USER_DVR1800_SetStartAddr(0, R_Alg_ID);			
				SACM_DVR1800_Play(Manual_Mode_Index, DAC1, Ramp_Up + Ramp_Dn);	
			}
			else if(Key == 0x0200)
			{
				R_TimeOut = C_TimeOut;
				R_PlayFlag = 1;
				R_Alg_ID = 3;

				SACM_DVR1800_Stop();	
				SACM_DVRIMA_Stop();	
				SACM_DVRIMA_Initial();													// DVRIMA initial
				USER_DVRIMA_SetStartAddr(0, R_Alg_ID, C_Play); 							// Addr, Bank, Read/Write Mode
				SACM_DVRIMA_Play(Manual_Mode_Index, DAC1 + DAC2, Ramp_Up + Ramp_Dn);	// manual mode playback
			}
			else
			{
				R_Command |= Key;
				ComwireLite_Send_Cmd(R_Command);
			}
		}
		Key = SP_GetKeyOff();
		Key &= 0x00FF;
		if(Key != 0)
		{
			R_Command &= ~Key;
			ComwireLite_Send_Cmd(R_Command);
		}

		if(ComwireLite_Is_Cmd_Rcvd())
		{
			Cmd = ComwireLite_Get_Cmd();
			Key = Cmd & 0x00FF;										// led display key
			R_Cmd_ID = Cmd & 0xF000;
			R_Cmd_ID >>= 12;
			Cmd &= 0x0F00;
			switch(Cmd)
			{
				case C_Erase:									
					R_TimeOut = C_TimeOut;
					R_PlayFlag = 0;
					SACM_DVRIMA_Stop();						
					SACM_DVR1800_Stop();						
					SACM_Delay();

					R_Alg_ID = R_Cmd_ID;
					if(R_Alg_ID == 1)
					{
						SPI_Flash_Block_Erase(R_Alg_ID);				
					}
					else
					{
						SPI_Flash_Block_Erase(R_Alg_ID);				
						SPI_Flash_Block_Erase(R_Alg_ID+1);				
					}
					SACM_Delay();
					ComwireLite_Send_Cmd(C_EraseEnd);
					SACM_Delay();
					ComwireLite_Send_Cmd(C_EraseEnd);
					break;
				case C_Start:
					R_TimeOut = C_TimeOut;
					R_PlayFlag = 0;
					R_Alg_ID = R_Cmd_ID;
					if(R_Alg_ID == 1)
					{
						SACM_DVR1800_Initial();		
						Mode = C_RecordData;
						USER_DVR1800_SetStartAddr(4, R_Alg_ID);			
						SACM_DVR1800_Rec(RecMonitorOff, Line_In1, DVR1800_BIT_RATE_16K);
					}
					else
					{
						SACM_DVRIMA_Initial();		// DVRIMA initial
						USER_DVRIMA_SetStartAddr(0, R_Alg_ID, C_Record); 	// Addr, Bank, Read/Write Mode
						SACM_DVRIMA_Rec(RecMonitorOff, Line_In1);
						SACM_DVRIMA_Timer(R_Alg_ID);
					}
					break;
				case C_End:
					R_TimeOut = C_TimeOut;
					R_PlayFlag = 0;
					if(R_Alg_ID == 1)
					{
						SACM_DVR1800_Stop();	
					}
					else
					{
						SACM_DVRIMA_Stop();	
					}
					SACM_Delay();
					break;
				case C_Status:			
					if(R_PlayFlag == 0)
					{
						R_TimeOut = C_TimeOut;
						R_PlayFlag = 0;
						ComwireLite_Send_Cmd(C_Ack);
					}
					break;
			}
			temp = *pP_IOB_Buffer;
			temp &= 0x00ff;
			temp |= Key << 8;
			*pP_IOB_Buffer = temp;
		}			
		System_ServiceLoop();
		ComwireLite_ServiceLoop();	
		if(R_Alg_ID == 1)		
			SACM_DVR1800_ServiceLoop();
		else	
			DVRIMA_ServiceLoop();
	}
	return 0;
}
