//
//  iOSAudioViewController.h
//  iOSAudio
//
//  Created by Generalplus SA1 on 2011/5/18.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AVFoundation/AVFoundation.h>
#import "ComWireHelpController.h"
#include "pthread.h"


#define COMMANDRETRYTIME             0.01     // sec
#define STATUSREFLASHTIME            0.2      // sec
#define KEYREFLASHTIME               0.01     // sec
#define ERASHCHECKTIME               1        //

#define MAXBUTTON                    8

#define SOUNDSTART_CMD               0x0100
#define SOUNDEND_CMD                 0x0200
#define SOUNDACK_CMD                 0x0300

#define SOUNDERASE_CMD               0x0400
#define SOUNDERASEEND_CMD            0x0500
#define SOUNDACK_STATUS              0x0600


#define ACK_CHECK_TIME               STATUSREFLASHTIME
//----------------------------------------------------------------

@interface iOSAudioViewController : UIViewController <AVAudioPlayerDelegate>{

	UISegmentedControl				*UISegRecSwitch;
	
	UILabel							*UILabelCommand;
	UILabel							*UILabelSendKeyValue;	
	UILabel							*UILabelHeadSetNotify;
	UILabel							*UILabelVersion;
	
	UIButton                        *UIButtonKeyAry[MAXBUTTON];
	UIImageView						*UIKeybuttonHighLightArray[MAXBUTTON];	
	

	int                             m_i32Command;
	unsigned char                   m_byKeyMap;
	
	NSTimer							*m_ErashTimer;	
	NSTimer							*m_UIReflashTimer;
	NSTimer							*m_UIStatusTimer;
	NSTimer							*m_PlayerPollingTimer;

	NSTimeInterval                  m_PreCheckTime;
	UISegmentedControl				*UISegWavSwtich;	
	
	UIViewController                *m_HelpView;
	BOOL                            m_i32IsStart;
	BOOL                            m_bIsErashEnd;
	BOOL                            m_bIsGetAck;
	
	NSData                          *m_pAudioPlayerData;         
	void                            *m_pAudioData;
	float                           m_fPlayRate;	
	
	AVAudioPlayer					*m_audioPlayer;
	UIProgressView                  *UIaudioPlayerProgress;
	UILabel							*UILabelPlayPercent;
	
}

@property(nonatomic,retain) IBOutlet UIActivityIndicatorView	*UIRecActive;
@property(nonatomic,retain) IBOutlet UILabel					*UILabelCommand;
@property(nonatomic,retain) IBOutlet UILabel					*UILabelSendKeyValue;
@property(nonatomic,retain) IBOutlet UILabel					*UILabelHeadSetNotify;
@property(nonatomic,retain) IBOutlet UILabel					*UILabelVersion;
@property(nonatomic,retain) IBOutlet UIProgressView				*UIaudioPlayerProgress;
@property(nonatomic,retain) IBOutlet UILabel					*UILabelPlayPercent;
@property(nonatomic,retain) IBOutlet UISegmentedControl			*UISegWavSwtich;

-(void) StartComWire:(BOOL)bStart;
-(void) DetectHeadSet;
-(void) CreateButton;

-(IBAction) ChangePlayRate:(id)sender;
-(IBAction) ChangeWave:(id)sender;
-(IBAction) PressKey:(id)sender;
-(IBAction) ReleaseKey:(id)sender;
-(IBAction) PressShowHelp:(id)sender;

-(void)		ErashCallback:(NSTimer*) timer;
-(void)		UIReFlashCallback:(NSTimer*) timer;
-(void)		UIStatusCallback:(NSTimer*) timer;
-(void)		CommandTimerCallback:(NSTimer*) timer;


@end

