//
//  iOSAudioViewController.m
//  iOSAudio
//
//  Created by Generalplus SA1 on 2011/5/18.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "iOSAudioViewController.h"
#include "ComWireLiteAPI.h"
#include "WavHeader.h"
#include <AudioToolbox/AudioToolbox.h>
#include <MacTypes.h>
#import <MediaPlayer/MediaPlayer.h>


//#define NOHANDSHAKE //debug by porter 20130418

static void *pMainUI = NULL;

@implementation iOSAudioViewController

@synthesize UIRecActive;
@synthesize UILabelCommand;
@synthesize UILabelHeadSetNotify;
@synthesize UILabelSendKeyValue;
@synthesize UILabelVersion,UIaudioPlayerProgress,UILabelPlayPercent,UISegWavSwtich;

//-----------------------------------------------------------------
-(IBAction) ChangePlayRate:(id)sender
{
	UISegmentedControl *pSwitch = (UISegmentedControl *) sender;
	int i32select = [pSwitch selectedSegmentIndex];
	
	switch(i32select)
	{
		case 0:
			m_fPlayRate = 1.0;
			break;
		case 1:
			m_fPlayRate = 3.0;
			break;

	}
	
}
//-----------------------------------------------------------------
-(IBAction) ChangeWave:(id)sender
{
	UISegmentedControl *pSwitch = (UISegmentedControl *) sender;
	int i32select = [pSwitch selectedSegmentIndex];
	
	if(m_audioPlayer!=nil)
	{
		[m_audioPlayer release];
		m_audioPlayer = nil;
	}
	
	if(m_ErashTimer)
	{
		[m_ErashTimer invalidate];
		m_ErashTimer = nil;	
	}
	
	NSString *SoundFilePath=nil;
	int i32Block;
	
	switch(i32select)
	{
		case 0:
		{
			UILabelPlayPercent.text = @"";
			UIaudioPlayerProgress.progress = 0.0;
			int i32Cmd = SOUNDEND_CMD;
			SendCommand((int*)&i32Cmd,1);
			
			int i;
			for(i=0;i<MAXBUTTON;i++)
			{
				UIButtonKeyAry[i].enabled = TRUE;
				UIButtonKeyAry[i].alpha = 1.0;
			}
			
			return;
		}
			break;
		case 1:
			SoundFilePath = [[NSBundle mainBundle] pathForResource: @"tailor1" ofType: @"wav"];
			break;
		case 2:
			SoundFilePath = [[NSBundle mainBundle] pathForResource: @"tailor2" ofType: @"wav"];
			break;
		case 3:
			SoundFilePath = [[NSBundle mainBundle] pathForResource: @"tailor3" ofType: @"wav"];
			break;
		case 4:
			SoundFilePath = [[NSBundle mainBundle] pathForResource: @"tailor4" ofType: @"wav"];
			break;		
	}
	
	m_bIsErashEnd = FALSE;

    BYTE byAlg = (BYTE) m_fPlayRate;
    
	int i32Cmd = SOUNDERASE_CMD;
    i32Cmd |= (byAlg << 12);
	SendCommand((int*)&i32Cmd,1);
	
	UILabelPlayPercent.text = @"Erasing";
	
	m_ErashTimer = [NSTimer scheduledTimerWithTimeInterval:ERASHCHECKTIME
													target:self 
												  selector:@selector(ErashCallback:) 
												  userInfo:nil 
												   repeats:NO];
	
	const char *pFilePath = [SoundFilePath UTF8String];
	
	FILE *fp = fopen(pFilePath,"r");
	
	fseek(fp, 0, SEEK_END);
	UInt32 u32FileSize = (UInt32)ftell(fp);
	fseek(fp, 0, SEEK_SET);

	m_pAudioData = malloc(u32FileSize);
	if (m_pAudioData) {
		
		fread(m_pAudioData, u32FileSize, 1, fp);

		WaveHeaderFile *pWaveHeader = (WaveHeaderFile *)m_pAudioData;
		pWaveHeader->i32SampleRate = pWaveHeader->i32SampleRate * m_fPlayRate;
		
		m_pAudioPlayerData = nil;
		
		m_pAudioPlayerData = [NSData dataWithBytes:m_pAudioData length:u32FileSize]; 
		
		free(m_pAudioData);
		
		
		m_audioPlayer = [[AVAudioPlayer alloc]initWithData:m_pAudioPlayerData error: nil];;
		m_audioPlayer.numberOfLoops = 0;
		m_audioPlayer.pan = -1.0; //left channel
		m_audioPlayer.delegate = self;
		
		int i;
		for(i=0;i<MAXBUTTON;i++)
		{
			UIButtonKeyAry[i].enabled = FALSE;
			UIButtonKeyAry[i].alpha = 0.5;	
		}
	}
	
	fclose(fp);
}
//-----------------------------------------------------------------
- (void)audioPlayerDidFinishPlaying:(AVAudioPlayer *)player successfully:(BOOL)flag
{
	UILabelPlayPercent.text = @"100/100";
	UIaudioPlayerProgress.progress = 1.0;
	
	if(m_audioPlayer!=nil)
	{
		[m_audioPlayer release];
		m_audioPlayer = nil;
	}
	
	int i32Cmd = SOUNDEND_CMD;
	SendCommand((int*)&i32Cmd,1);
	
	int i;
	for(i=0;i<MAXBUTTON;i++)
	{
		UIButtonKeyAry[i].enabled = TRUE;
		UIButtonKeyAry[i].alpha = 1.0;	
	}
}
//-----------------------------------------------------------------
-(void)		ErashCallback:(NSTimer*) timer
{
#ifdef NOHANDSHAKE
	[m_ErashTimer invalidate];
	m_ErashTimer = nil;
	[m_audioPlayer play];
#else
	
	if(m_audioPlayer!=nil && m_bIsErashEnd)
	{
		[m_ErashTimer invalidate];
		m_ErashTimer = nil;
		
		BYTE bySpeed = (BYTE) m_fPlayRate;
		int i32Cmd = SOUNDSTART_CMD | (bySpeed << 12);	
		
		SendCommand((int*)&i32Cmd,1);
	
		m_bIsGetAck = TRUE; // Do not check first time
		m_PreCheckTime= [NSDate timeIntervalSinceReferenceDate];
		[m_audioPlayer play];
	}
	else
	{
		if(m_audioPlayer!=nil)
		{
			[m_audioPlayer release];
			m_audioPlayer = nil;
		}
		
		[m_ErashTimer invalidate];
		m_ErashTimer = nil;
		
		UILabelPlayPercent.text = @"Failed!E";
	}
#endif
	
}
//-----------------------------------------------------------------
-(IBAction) PressShowHelp:(id)sender
{	
	if(m_HelpView == nil)
	{
		if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) 
		{
			m_HelpView = [[ComWireHelpController alloc] initWithNibName:@"ComWireHelpViewiPhone" bundle:nil];
		}
		else
		{
			m_HelpView = [[ComWireHelpController alloc] initWithNibName:@"ComWireHelpViewiPad" bundle:nil];
		}
		
		[self.view addSubview:m_HelpView.view];
		m_HelpView.view.alpha = 0.0f;
	}

	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:0.5f];
	
	[CATransaction setDisableActions:NO];
	m_HelpView.view.alpha = 1.0f;
	
}

//-----------------------------------------------------------------
-(void) StartComWire:(BOOL)bStart
{
	if(bStart)
	{
		[UIRecActive startAnimating];
		
		StartComWireLite();
		
		// start reflash UI timer
		m_UIReflashTimer = [NSTimer scheduledTimerWithTimeInterval:KEYREFLASHTIME
											 target:self 
										     selector:@selector(UIReFlashCallback:) 
										     userInfo:nil 
											repeats:YES];
		
		
		m_UIStatusTimer = [NSTimer scheduledTimerWithTimeInterval:STATUSREFLASHTIME
															target:self 
														  selector:@selector(UIStatusCallback:) 
														  userInfo:nil 
														   repeats:YES];
		m_i32IsStart = TRUE;
		
	}
	else
	{

		[m_UIReflashTimer invalidate];
		m_UIReflashTimer = nil;
	
		[m_UIStatusTimer invalidate];
		m_UIStatusTimer = nil;
		
		[UIRecActive stopAnimating];
		StopComWireLite();
		
		m_i32IsStart = FALSE;
	}

}
//-----------------------------------------------------------------
-(IBAction) PressKey:(id)sender
{
	int i;
	for(i=0;i<MAXBUTTON;i++)
	{
		if(sender == UIButtonKeyAry[i])
			break;
	}
	
	m_byKeyMap |=  1 << i;
	

	SendCommand((int*)&m_byKeyMap,1);
	

}
//-----------------------------------------------------------------
-(IBAction) ReleaseKey:(id)sender
{
	int i;
	for(i=0;i<MAXBUTTON;i++)
	{
		if(sender == UIButtonKeyAry[i])
			break;
	}
	
	m_byKeyMap &=  ~(1 << i);
	
	SendCommand((int*)&m_byKeyMap,1);
		
}
//-----------------------------------------------------------------
-(IBAction) SaveRawData:(id)sender
{
	UISwitch *pSwitch = (UISwitch*)sender;
	
	if(pSwitch.on == YES)
	{
		SetSaveRawData(TRUE);
	}
	else
	{		
		SetSaveRawData(FALSE);
	}

}
//-----------------------------------------------------------------
-(void)     DetectHeadSet
{
	UInt32 routeSize = sizeof (CFStringRef);
	CFStringRef route;
	
	OSStatus error = AudioSessionGetProperty (kAudioSessionProperty_AudioRoute,
											  &routeSize,
											  &route);
	
	/* Known values of route:
	 * "Headset"
	 * "Headphone"
	 * "Speaker"
	 * "SpeakerAndMicrophone"
	 * "HeadphonesAndMicrophone"
	 * "HeadsetInOut"
	 * "ReceiverAndMicrophone"
	 * "Lineout"
	 */
	
#ifdef NOHANDSHAKE

#else
	
	if(CFStringCompare(route,(CFStringRef)@"HeadsetInOut",0) == 0)
	{
		NSString *sOutMsg = [[NSString alloc]initWithFormat:@"Detected headset."];
		UILabelHeadSetNotify.text	=	sOutMsg;
		[sOutMsg release];

		
		[self StartComWire:TRUE];
		UISegWavSwtich.enabled = TRUE ; 
		
		if(m_audioPlayer!=nil)
		{
			//force to play in left channel
			[m_audioPlayer stop];
			m_audioPlayer.pan = -1.0;
            [m_audioPlayer play];
		}
	
	}
	else
	{
		NSString *sOutMsg = [[NSString alloc]initWithFormat:@"Please insert headset."];
		UILabelHeadSetNotify.text	=	sOutMsg;
		[sOutMsg release];
		
		[self StartComWire:FALSE];
		UISegWavSwtich.enabled = FALSE ;	
		
		if(m_audioPlayer!=nil)
			[m_audioPlayer stop];
		
		m_bIsGetAck = FALSE;
	}
	
#endif
}
//-----------------------------------------------------------------
-(void) UIReFlashCallback:(NSTimer*) timer
{
	int i32BitMask = 0x01;
	for(int i=0;i<MAXBUTTON;i++)
	{
		if(((m_i32Command >> i) & i32BitMask)>0)
			UIKeybuttonHighLightArray[i].hidden = false;
		else
			UIKeybuttonHighLightArray[i].hidden = true;
		
	}
	
}
//-----------------------------------------------------------------
-(void) UIStatusCallback:(NSTimer*) timer
{
	// update info
	NSString *sOutMsg = [[NSString alloc]initWithFormat:@"0x%x",m_i32Command];
	UILabelCommand.text	=	sOutMsg;
	[sOutMsg release];
	
	sOutMsg = [[NSString alloc]initWithFormat:@"0x%x",m_byKeyMap];
	UILabelSendKeyValue.text	=	sOutMsg;
	[sOutMsg release];
	
	
	if(m_audioPlayer!=nil)
	{
		if([m_audioPlayer isPlaying])
		{
			float fPlayPercent = (m_audioPlayer.currentTime/m_audioPlayer.duration);
			
			sOutMsg = [[NSString alloc]initWithFormat:@"%d/100",(int)(fPlayPercent * 100)];
			UILabelPlayPercent.text	=	sOutMsg;
			[sOutMsg release];
			
			UIaudioPlayerProgress.progress = fPlayPercent;
			
            #ifdef NOHANDSHAKE
			
            #else
			if([NSDate timeIntervalSinceReferenceDate] - m_PreCheckTime > ACK_CHECK_TIME)
			{
				if(!m_bIsGetAck)
				{
					sOutMsg = [[NSString alloc]initWithFormat:@"Failed!D"];
					UILabelPlayPercent.text	=	sOutMsg;
					[sOutMsg release];
					
					if(m_audioPlayer!=nil)
					{
						[m_audioPlayer release];
						m_audioPlayer = nil;
					}
					
					int i;
					for(i=0;i<MAXBUTTON;i++)
					{
						UIButtonKeyAry[i].enabled = TRUE;
						UIButtonKeyAry[i].alpha = 1.0;
					}
					
					return ;
				}
				
				int i32Cmd = SOUNDACK_STATUS; //polling status
				SendCommand((int*)&i32Cmd,1);
				m_PreCheckTime= [NSDate timeIntervalSinceReferenceDate];
				m_bIsGetAck = FALSE;
				
			}
            #endif
		}
	}
	
}
//-----------------------------------------------------------------
int UserCallBack(int  i32Commnad)
{
	iOSAudioViewController *pUIController = (iOSAudioViewController *)pMainUI;
	pUIController->m_i32Command = i32Commnad;
	
	if(i32Commnad==SOUNDACK_CMD)
		pUIController->m_bIsGetAck = TRUE;	
	else if(i32Commnad==SOUNDERASEEND_CMD)
		pUIController->m_bIsErashEnd = TRUE;
	
	return 0;
}

//-----------------------------------------------------------------
void propListener(	void *                  inClientData,
				  AudioSessionPropertyID	inID,
				  UInt32					inDataSize,
				  const void *				inData)
{
	iOSAudioViewController *pUIController = (iOSAudioViewController *)inClientData;
	if (inID == kAudioSessionProperty_AudioRouteChange)
	{
		[pUIController DetectHeadSet];
	}
}

//--------------------------------------------------------------------
/*
// The designated initializer. Override to perform setup that is required before the view is loaded.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}
*/

/*
// Implement loadView to create a view hierarchy programmatically, without using a nib.
- (void)loadView {
}
*/

//--------------------------------------------------------------------
-(void) CreateButton
{
	
	CGFloat ButtonWidth;
	CGFloat ButtonY;
	CGFloat ButtonXShift;
	
	
	if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) 
	{

		ButtonWidth = (self.view.frame.size.width - 40) / MAXBUTTON;
		ButtonY = (self.view.frame.size.height/4) * 3;
		ButtonXShift = 2;	
	}
	else
	{
		ButtonWidth = (self.view.frame.size.width - 120) / MAXBUTTON;
		ButtonY = (self.view.frame.size.height/4) * 3;
		ButtonXShift = 50;
	}

	//create buttons
	NSInteger x;
	for (x = 0; x < MAXBUTTON ; x++) 
	{
		CGRect frame,hlframe;
		frame = CGRectMake(ButtonXShift + x * (ButtonWidth+5) , ButtonY , ButtonWidth, ButtonWidth * 2);
		
		UIButton *button = [UIButton buttonWithType:UIButtonTypeRoundedRect];
		UIKeybuttonHighLightArray[x] = [[UIImageView alloc] initWithImage:[UIImage imageNamed: @"Light.png"]];
		UIKeybuttonHighLightArray[x].hidden = true;
		
		[button addTarget:self action:@selector(PressKey:) forControlEvents:UIControlEventTouchDown];
		
		[button addTarget:self action:@selector(ReleaseKey:) forControlEvents:UIControlEventTouchUpInside];
		[button addTarget:self action:@selector(ReleaseKey:) forControlEvents:UIControlEventTouchUpOutside];
		[button addTarget:self action:@selector(ReleaseKey:) forControlEvents:UIControlEventTouchCancel];
		
		button.frame = frame;
		button.tag = x;
		
		NSString *sTitle= [[NSString alloc]initWithFormat:@"0x%.2x", 1<<x];
		[button setTitle: sTitle forState: UIControlStateNormal];
		[sTitle release];

		[button addSubview:UIKeybuttonHighLightArray[x]];
		
		hlframe = CGRectMake(2, 0 , ButtonWidth-5, ButtonWidth-5);
		UIKeybuttonHighLightArray[x].frame = hlframe;
		
		[self.view addSubview:button];
		
		UIButtonKeyAry[x] = button;
		
	}	
	
}

//--------------------------------------------------------------------
void VolumeListener(void *                  inClientData,
					AudioSessionPropertyID	inID,
					UInt32					inDataSize,
					const void *			inData)
{
	MPMusicPlayerController *pController = [MPMusicPlayerController iPodMusicPlayer];
	pController.volume = 1.0;
}
//--------------------------------------------------------------------
// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {

	[[UIApplication sharedApplication]setIdleTimerDisabled:YES];

	SetSaveRawData(FALSE);
	InitComWireLite();
	SetBitMode(ComWireLiteBitMode_16Bit);
	SetComWireLiteTxChannelMode(eComWireLiteTxChannelMode_Right);
	
	pMainUI = self;
	PFN_ComWireLiteUserCallBack pfnCallBack = &UserCallBack;
	SetComWireLiteUserCallBack(pfnCallBack);
	m_HelpView = nil;
	
	UILabelCommand.text		=	@"0";
	UILabelSendKeyValue.text=   @"0";
	m_i32Command = 0;
	m_byKeyMap = 0;
	m_i32IsStart = FALSE;
	
	m_PlayerPollingTimer = nil;
	m_audioPlayer = nil;
	UILabelPlayPercent.text = @"";
	m_ErashTimer = nil;
	m_fPlayRate = 1.0;
	m_pAudioData = NULL;
	m_pAudioPlayerData = NULL;
	[self CreateButton];
	
	UILabelVersion.text = [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleVersion"];
	AudioSessionAddPropertyListener(kAudioSessionProperty_AudioRouteChange, propListener, self);
	[self DetectHeadSet];
	
	AudioSessionAddPropertyListener(kAudioSessionProperty_CurrentHardwareOutputVolume, VolumeListener, self);
	
	MPMusicPlayerController *pController = [MPMusicPlayerController iPodMusicPlayer];
	pController.volume = 1.0;
	
	
    [super viewDidLoad];
}



// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
	//return YES;
	return UIInterfaceOrientationIsPortrait(interfaceOrientation);
}


- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
	
	[UIRecActive stopAnimating];
	StopComWireLite();
	[UISegRecSwitch setSelectedSegmentIndex:1];

}


- (void)dealloc {
	[UIRecActive release];
	[UISegRecSwitch release];
	
	[UILabelCommand release];	
	UnitComWireLite();
	
	
	int i;
	for(i=0;i<MAXBUTTON;i++)
		[UIKeybuttonHighLightArray[i] release];
	
	if(m_HelpView)
		[m_HelpView release];
	
    [super dealloc];
}

@end
