/*
 *  ComWireLiteAPI.h
 *  ComWireLite V1.0.3
 *
 *  Created by Generalplus SA1 on 2013/3/25.
 *  Copyright 2013 GeneralPlus. All rights reserved.
 *
 */

#ifndef _ComWireLiteAPI_H
#define _ComWireLiteAPI_H
#include <MacTypes.h>

#define BYTE unsigned char 

#if defined(__cplusplus)
extern "C" {
#endif
//--------------------------------------------------	
//Error code	
//--------------------------------------------------	
#define		COMWIRELITE_NOERR					0
#define		COMWIRELITE_AUIDOUINTFAILED			1
#define		COMWIRELITE_ENABLEIORECFAILED		2
#define		COMWIRELITE_SETFORMATFAILED			3
#define		COMWIRELITE_SETRECCALLBACKFAILED	4
#define		COMWIRELITE_ALLOCBUFFAILED			5
#define		COMWIRELITE_AUDIONOTINIT			6
#define		COMWIRELITE_SETDECODEMODEFAILED		7
#define		COMWIRELITE_SENDCMDQUEUEBUSY	    8
#define		COMWIRELITE_SENDCMDSIZELIMIT	    9
//--------------------------------------------------	
//Defines	
//--------------------------------------------------
#define      MAX_COMMAND_QUEUE_SIZE             256
	
typedef int (*PFN_ComWireLiteUserCallBack) (int i32Command);	
	
typedef enum tagComWireLiteTxChannelMode
{
	eComWireLiteTxChannelMode_Default	= 0,
	eComWireLiteTxChannelMode_Left		= 1,
	eComWireLiteTxChannelMode_Right		= 2
		
}E_ComWireLiteTxChannelMode;	
	
typedef enum tagComWireLiteBitMode
{
	ComWireLiteBitMode_8Bit	    = 8,
	ComWireLiteBitMode_16Bit	= 16,
		
}E_ComWireLiteBitMode;	
	
//-------------------------------------------------	
//Functions	
//-------------------------------------------------	
	
int		InitComWireLite();
int		UnitComWireLite();	
	
int		StartComWireLite();
int		StopComWireLite();

int     SendCommand(
		int  *pi32CommandArray,
		int   i32ArryCmdSize
		);
	
int     GetLastCommand(int *i32Command);	
	
int		SetComWireLiteUserCallBack(PFN_ComWireLiteUserCallBack pfnUserCallBack);

int     EnableComWireLiteTx(bool bEnable);	
int     EnableComWireLiteRx(bool bEnable);		
	
int     SetComWireLiteTxChannelMode(E_ComWireLiteTxChannelMode eMode);	
E_ComWireLiteTxChannelMode     GetComWireLiteTxChannelMode();	
	
int     SetSaveRawData(bool bEnable);
int     SetBitMode(E_ComWireLiteBitMode eMode);	
	
#if defined(__cplusplus)
}
#endif

#endif